﻿(function () {
    'use strict';

    var controllerId = 'membersController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId, ['$scope', 'membershipdataservices', 'notificationFactory', 'dataservices', 'ngTableParams', '$filter', '$upload', membersController]);

    function membersController($scope, membershipdataservices, notificationFactory, dataservices, ngTableParams, $filter, $upload) {
        $scope.title = 'membersController';
        $scope.activate = activate;

        $scope.data = membershipdataservices;
        $scope.membershipData = [];
        $scope.selectionValue = false;

        if (membershipdataservices.IsMembersDataInitialized() == false) {

            membershipdataservices.getAllMembersData().then(function () {
                //the Table Paramemters
                ngTableFunction();

            }, function () { });

        } else {
            ngTableFunction();
        }
       
        ///This method handles the all selection and deselection of members
        $scope.UpdateAllSelection = function (peopleArray, selectionValue) {

            for (var i = 0; i < peopleArray.length; i++) {
                peopleArray[i].isSelected = selectionValue;
            }
        }

        //load the email drafts
        $scope.loadEmailTemplates = function () {
            dataservices.getEmailDrafts().then(function (emails) {

                $("#emaildraftselect").select2({
                    placeholder: 'Select From Drafts',
                    data: emails,
                    width: "100%"         //

                }).on("change", function (e) {

                    //call the get email service

                    dataservices.getEmailDraftByID(e.val).then(function (emaildraft) {

                        $scope.emailSubject = emaildraft.subject;
                        $scope.emailMessage = emaildraft.message;
                        $('#emailMessage').data("wysihtml5").editor.setValue(emaildraft.message);


                    }, function () {
                        //error
                        notificationFactory.error("Unsuccessful");

                    });

                });

            }, function () {
                // error
                notificationFactory.error('Could not load saved email drafts from the server. kindly enter email manually.');
            });
        }
        //Generate Identification numbers for the members of the church
        $scope.GenerateNumbers = function () {
            if (confirm('Are you sure you want to run this process?') == true) {
                notificationFactory.info("This is a long running process, kindly continue with other operations, the system will alert you when the operation is completed.");

                membershipdataservices.generateNumbers().then(function () {

                    notificationFactory.success("Membership Identification numbers successful generated and sent");



                }, function () {
                    notificationFactory.error("Unsuccessful");

                });
            }
        }

        //Load the sms templates
        $scope.loadSMSTemplates = function () {
            dataservices.getSMSDrafts().then(function (sms) {
                $("#smsdraftselect").select2({
                    placeholder: 'Select From SMS Drafts',
                    data: sms,
                    width: "100%"
                }).on("change", function (e) {

                    //call the get email service

                    dataservices.getSMSDraftByID(e.val).then(function (smsdraft) {

                        $scope.smsSubject = smsdraft.sender;
                        $scope.smsMessage = smsdraft.body;

                    }, function () {

                        //Error
                        notificationFactory.error("Unsuccessful");

                    });

                });

            }, function () {

                //Error
                notificationFactory.error('Could not load saved sms drafts from the server. kindly enter email manually.');


            });
        }

        //Refreshes the dataset, since that the data is cached, when other users update data, one might need to refresh the data.
        $scope.Refresh = function () {
            membershipdataservices.getAllMembersData().then(function () { },
                function () {
                    //Error refreshing data set
                    notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
                });;

        }

        $scope.Delete = function () {
            if (getSelectedMembers().length < 1) {
                notificationFactory.error('Please select contact to delete');
            }
            else {
                //make a call to the delete service pass the array of contacts

                membershipdataservices.deleteMembersInformation(getSelectedMembers()).then(function (result) {

                    notificationFactory.success(result + ' Deleted');

                },
                 function () {
                     notificationFactory.error('Delete not successful, please check the internet and try again.');


                 });
            }
        }

        //Send SMS Method, this checks if the client has enough credit before the sms operation is activated.
        $scope.SendSMS = function () {

            if (getSelectedMembers().length < 1) {
                notificationFactory.error('Please select contact to send sms');
            }
            else {


                var messageObject = {};
                messageObject.subject = $scope.smsSubject;
                messageObject.message = $scope.smsMessage;
                messageObject.contacts = getSelectedMembers();
                //check if the client has enough unit to send sms


                //If true then send the sms.
                dataservices.sendSMS(messageObject).then(function () {

                    notificationFactory.success('SMS successfully sent');

                }, function () {

                    notificationFactory.error('There was an error sending SMS, please check your internet connection and try again.');

                });
            }


        }

        //Send Email Operation, this calls the base functionality factory dataservices.
        $scope.SendEmail = function () {
            if (getSelectedMembers().length < 1) {
                notificationFactory.error('Please select contact to send email');
            }
            else {
                var messageObject = {};
                messageObject.subject = $scope.emailSubject;
                messageObject.message = $('#emailMessage').val();

                messageObject.contacts = getSelectedMembers();
                //post this to the dataservice factory that will serve as the common functionality base.

                dataservices.sendEmails(messageObject).then(function () {
                    notificationFactory.success('Emails successfully sent');
                }, function () {
                    // error
                    notificationFactory.error('There was an error sending email, please check your internet connection and try again.');
                });
            }

        }

        ///The function for NgTable
        function ngTableFunction() {
            $scope.tableParams = new ngTableParams({
                page: 1,            // show first page
                count: 100,           // count per page
                sorting: {
                    name: 'asc'     // initial sorting
                }, filter: {
                    name: ''       // initial filter
                },
            }, {
                total: $scope.data.membersData.length, // length of data
                getData: function ($defer, params) {

                    // use build-in angular filter
                    var filteredData = params.filter() ?
                            $filter('filter')($scope.data.membersData, params.filter()) :
                            $scope.data.membersData;
                    var orderedData = params.sorting() ?
                            $filter('orderBy')(filteredData, params.orderBy()) :
                            $scope.data.membersData;
                    params.total(orderedData.length); // set total for recalc pagination                    
                    $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));

                    $("th").removeClass("filter ng-scope");

                }
            });
        }


        function getSelectedMembers() {
            var contactArray = [];
            for (var i = 0; i < $scope.data.membersData.length; i++) {

                if ($scope.data.membersData[i].isSelected == true) {
                    var contact = {};

                    contact.id = $scope.data.membersData[i].id;
                    contact.name = $scope.data.membersData[i].name;
                    contact.phone = $scope.data.membersData[i].phone;
                    contact.email = $scope.data.membersData[i].email;
                    contactArray.push(contact);
                }
            }

            return contactArray;
        }

        //////////////////////// file upload
        $scope.onFileSelect = function ($files) {
            $scope.selectedFile = $files[0];
        };

        $scope.UploadExcelFile = function () {
            $scope.upload = $upload.upload({
                url: 'api/ExcelUploadController/UploadExcelFile',
                method: "POST",
                file: $scope.selectedFile

            }).success(function (data, status, headers, config) {
                membershipdataservices.getAllMembersData().then(function () { },
               function () {
                   //Error refreshing data set
                   notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
               });
                notificationFactory.success(data.response);
            });

        }


        $('.editor').wysihtml5({
            stylesheets: "css/wysihtml5/wysiwyg-color.css"
        });



        $('.bar-success').sparkline(
     'html', { type: 'bar', barColor: '#ffffff', height: '30px', barWidth: "4px", barSpacing: "2px", zeroAxis: "true" }
 );
        function activate() { }
    }
})();


