﻿(function () {
    'use strict';

    var serviceId = 'membershiprepository';

    // TODO: replace app with your module name
    churchplusapp.factory(serviceId, ['$http', '$q', membershiprepository]);
    function membershiprepository($http, $q) {
        // Define the functions and properties to reveal.
        var _membershipData = [];
        var _initmembershipData = false;

        var service = {
            getAllMembershipData: getAllMembershipData,
            membershipData: _membershipData,          
            getFirstTimersData: getFirstTimersData,
            getNewConvertsData: getNewConvertsData,
            IsMembershipDataInitialized: IsMembershipDataInitialized


        };

        return service;

        function getAllMembershipData() {
            var deferred = $q.defer();
            $http.get('/api/MembershipController/getAllMembershipData').then(function (result) {
                //successful call
                angular.copy(result.data, _membershipData);
                _initmembershipData = true;

                deferred.resolve();
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        function IsMembershipDataInitialized()
        {
            return _initmembershipData;

        }

        function getAllMembershipData() {

            return _membershipData;

        }

        function getFirstTimersData() {
            return _membershipData;
        }

        function getNewConvertsData() {

            return _membershipData;
        }


        //#region Internal Methods        

        //#endregion
    }
})();