﻿(function () {
    'use strict';

    var serviceId = 'membershipdataservices';

    // TODO: replace app with your module name
    churchplusapp.factory(serviceId, ['$http', '$q', membershipdataservices]);

    function membershipdataservices($http, $q) {
        // Define the functions and properties to reveal.

        var _membershipData = [];
        var _firstTimersData = [];
        var _newConvertsData = [];
        var _membersData = [];

        var _initmembershipData = false;
        var _initFirstTimersData = false;
        var _initNewConvertsData = false;
        var _initMembersData = false;

        var service = {

            membershipData: _membershipData,
            firstTimersData: _firstTimersData,
            newConvertsData: _newConvertsData,
            membersData: _membersData,

            getAllMembershipData: getAllMembershipData,
            getAllFirstTimersData: getAllFirstTimersData,
            getAllNewConvertsData: getAllNewConvertsData,
            getAllMembersData: getAllMembersData,

            deleteMembersInformation: deleteMembersInformation,
            deleteFirstTimersInformation: deleteFirstTimersInformation,
            deleteNewConvertsInformation: deleteNewConvertsInformation,
            deleteNote:deleteNote,
            generateNumbers:generateNumbers,
            IsMembershipDataInitialized: IsMembershipDataInitialized,
            IsFirstTimersDataInitialized: IsFirstTimersDataInitialized,
            IsMembersDataInitialized: IsMembersDataInitialized,
            IsNewConvertDataInitialized: IsNewConvertDataInitialized,

            SaveMemberInformation: SaveMemberInformation,
            SaveFirstTimer: SaveFirstTimer,
            SaveNewConvert: SaveNewConvert,
            getSingleContactInformation: getSingleContactInformation
        };

        return service;

        function generateNumbers()
        {
            var deferred = $q.defer();
            $http.get('/api/MembershipController/generateNumbers').then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }


        function getAllMembershipData() {
            var deferred = $q.defer();
            $http.get('/api/MembershipController/getAllMembershipData').then(function (result) {
                //successful call
                angular.copy(result.data, _membershipData);
                _initmembershipData = true;
                deferred.resolve(_membershipData);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        function getAllFirstTimersData() {

            var deferred = $q.defer();
           
                $http.get('api/MembershipController/getAllFirstTimersData').then(function (result) {
                    //successful call
                    angular.copy(result.data, _firstTimersData);
                    _initFirstTimersData = true;

                    deferred.resolve();
                },
                function () {
                    //error in call
                    deferred.reject();
                });
           
            return deferred.promise;
        }
        function getAllNewConvertsData() {

            var deferred = $q.defer();
           
                $http.get('/api/MembershipController/getAllNewConvertsData').then(function (result) {
                    //successful call
                    angular.copy(result.data, _newConvertsData);
                    _initNewConvertsData = true;

                    deferred.resolve();
                },
                function () {
                    //error in call
                    deferred.reject();
                });
           
            return deferred.promise;

        }
        function getAllMembersData() {
            var deferred = $q.defer();
           
                $http.get('/api/MembershipController/getAllFullMembers').then(function (result) {
                    //successful call
                    angular.copy(result.data, _membersData);
                    _initMembersData = true;

                    deferred.resolve();
                },
                function () {
                    //error in call
                    deferred.reject();
                });
           
            return deferred.promise;
        }
        
        //Delete function passing the selected contacts list.
        function deleteNote(id) {
            var deferred = $q.defer();
            $http({
                method: 'delete',
                url: 'api/MembershipController/deleteNote',
                params: { id: id }
            }).then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
                function () {
                    //error in call
                    deferred.reject();
                });

            return deferred.promise;
        }

        //Delete function passing the selected contacts list.
        function deleteMembersInformation(contacts) {
            var deferred = $q.defer();
            $http.post('/api/MembershipController/RemoveMemberFromDatabase/', contacts).then(function (result) {

                //remove the deleted contacts from the local dataset
                var itemsToDelete = [];

                for (var a = 0; a < result.data.length; a++) {

                    if (result.data[a].status == 'deleted') {
                        for (var i = 0; i < _membershipData.length; i++) {

                            if (_membershipData[i].id == result.data[a].id) {

                                _membershipData.splice(_membershipData.indexOf(_membershipData[i]), 1);
                                itemsToDelete.push(_membershipData[i].id);
                            }
                        }

                    }
                }

                var r = itemsToDelete.length.toString() + ' of selected ' + contacts.length.toString();

                deferred.resolve(r);

            }, function (result) {

                deferred.reject(result.data);
            });

            return deferred.promise;
        }

        //Delete firstTimers function passing the selected contacts list.
        function deleteFirstTimersInformation(contacts) {
            var deferred = $q.defer();
            $http.post('/api/MembershipController/RemoveFirstTimerFromDatabase/', contacts).then(function (result) {

                //remove the deleted contacts from the local dataset
                var itemsToDelete = [];

                for (var a = 0; a < result.data.length; a++) {

                    if (result.data[a].status == 'deleted') {
                        for (var i = 0; i < _firstTimersData.length; i++) {

                            if (_firstTimersData[i].id == result.data[a].id) {

                                _firstTimersData.splice(_firstTimersData.indexOf(_firstTimersData[i]), 1);
                                itemsToDelete.push(_firstTimersData[i].id);
                            }
                        }

                    }
                }

                var r = itemsToDelete.length.toString() + ' of selected ' + contacts.length.toString();

                deferred.resolve(r);

            }, function (result) {

                deferred.reject(result.data);
            });

            return deferred.promise;
        }

        //Delete firstTimers function passing the selected contacts list.
        function deleteNewConvertsInformation(contacts) {
            var deferred = $q.defer();
            $http.post('/api/MembershipController/RemoveNewConvertsFromDatabase/', contacts).then(function (result) {

                //remove the deleted contacts from the local dataset
                var itemsToDelete = [];

                for (var a = 0; a < result.data.length; a++) {

                    if (result.data[a].status == 'deleted') {
                        for (var i = 0; i < _newConvertsData.length; i++) {

                            if (_newConvertsData[i].id == result.data[a].id) {

                                _newConvertsData.splice(_newConvertsData.indexOf(_newConvertsData[i]), 1);
                                itemsToDelete.push(_newConvertsData[i].id);
                            }
                        }

                    }
                }

                var r = itemsToDelete.length.toString() + ' of selected ' + contacts.length.toString();

                deferred.resolve(r);

            }, function (result) {

                deferred.reject(result.data);
            });

            return deferred.promise;
        }


        //Save First Timer Information.
        function SaveFirstTimer(person) {
            var deferred = $q.defer();
            $http.post('/api/MembershipController/SaveFirstTimerInformation/', person).then(function (result) {

                _firstTimersData.splice(0, 0, result.data);


                deferred.resolve(result.data);

            }, function (result) {

                deferred.reject(result.data);
            });

            return deferred.promise;

        }

        //Save New Convert Information.
        function SaveNewConvert(person) {
            var deferred = $q.defer();
            $http.post('/api/MembershipController/SaveNewConvertInformation/', person).then(function (result) {
                _newConvertsData.splice(0, 0, result.data);

                deferred.resolve(result.data);

            }, function (result) {

                deferred.reject(result.data);
            });

            return deferred.promise;

        }
        function SaveMemberInformation(person) {
            var deferred = $q.defer();
            $http.post('api/MembershipController/SaveContactinformation', person).then(function (result) {
                //successful call
                // Add the newly saved member to the membership dataset
                if (person.id != null) {

                    for (var i = 0; i < _membershipData.length; i++) {

                        if (_membershipData[i].id == person.id) {
                            _membershipData.splice(_membershipData.indexOf(_membershipData[i]), 1);

                        }
                    }
                }
                _membershipData.splice(0, 0, result.data);

                deferred.resolve();
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;

        }
        //Initialize the membership Data.

        function getSingleContactInformation(personID) {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: 'api/MembershipController/getSingleContactInformation',
                params: { id: personID }
            }).then(function (result) {
                //successful call
                result.data.firstName = result.data.firstName;
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        function IsMembershipDataInitialized() {
            return _initmembershipData;

        }
        function IsFirstTimersDataInitialized() {
            return _initFirstTimersData;

        }
        function IsMembersDataInitialized() {
            return _initMembersData;

        }
        function IsNewConvertDataInitialized() {
            return _initNewConvertsData;
        }


    }
})();