﻿(function () {
    'use strict';
    churchplusapp.factory('notificationDialog', ['$q', notificationsMsg]);

    function notificationsMsg($q) {

        return {

            alert: function (msg) {
                bootbox.alert("<h4>" + msg + "</h4>");
            },

            alart_callBack: function (msg) {
                var deferred = $q.defer();
                bootbox.alert("<h4>" + msg + "</h4>", function (result) {
                    deferred.resolve(result);
                });
                return deferred.promise;
            },

            confirm: function (msg) {
                var deferred = $q.defer();
                bootbox.confirm("<h4>" + msg + "</h4>", function (result) {
                    deferred.resolve(result);
                });
                return deferred.promise;
            },

            prompt: function (msg) {
                var deferred = $q.defer();
                bootbox.prompt("<h4>" + msg + "</h4>", function (result) {
                    deferred.resolve(result);
                });
                return deferred.promise;
            },

            message_custom: function (htmlContents) {
                var deferred = $q.defer();
                bootbox.alert(htmlContents);
                return deferred.promise;
            },

            confirm_custom: function (msg) {
                var deferred = $q.defer();
                bootbox.dialog({
                    message: "<h5 style='margin: 0 10px;'>" + msg + " </h5>",
                    title: "confirm action",
                    buttons: {
                        success: {
                            label: "OK",
                            className: "btn-success",
                            callback: function () {
                                deferred.resolve(true);
                            }
                        },
                        danger: {
                            label: "Cancel",
                            className: "btn-danger",
                            callback: function () {
                                deferred.resolve(false);
                            }
                        }
                    }
                });
                return deferred.promise;
            },

        };
    };

})();

