﻿(function () {
    'use strict';

    var serviceId = 'onlineGivingDataServices';

    // TODO: replace app with your module name
    churchplusapp.factory(serviceId, ['$http', '$q', onlineGivingDataServices]);


    function onlineGivingDataServices($http, $q) {
        // Define the functions and properties to reveal.
        var _donors = [];
        var _paymentTransactions = [];
        var _paymentTransactionDetails = [];
        var _allOfferingTransactions = [];
        var _churchHostNameValidationResult = null
        var _churchBankDetails = {};

        var service = {

            DonorsData: _donors,
            getDonorsData: getDonorsData,

            PaymentTransactions: _paymentTransactions,
            getPaymentTransactions: getPaymentTransactions,

            PaymentTransactionDetails: _paymentTransactionDetails,
            getPaymentTransactionDetails: getPaymentTransactionDetails,

            AllOfferingTransactions: _allOfferingTransactions,
            getAllOfferingTransactions: getAllOfferingTransactions,
            getPaymentTransactionStatus4Interswitch: getPaymentTransactionStatus4Interswitch,
            validateChurchHostName: validateChurchHostName,

            ChurchBankDetailsData: _churchBankDetails,
            saveChurchBankDetails: saveChurchBankDetails,
            loadChurchBankData: loadChurchBankData

        };


        return service;


        function getDonorsData() {
            var deferred = $q.defer();
            $http.get('api/AccountingFinancialController/GetFinancialOfferingContributionTransactions').then(function (result) {
                //successful call
                angular.copy(result.data, _donors);
                deferred.resolve();
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;
        }

        function getPaymentTransactions() {
            var deferred = $q.defer();
            $http.get('api/PaymentController/GetPaymentTransactions').then(function (result) {
                //successful call
                angular.copy(result.data, _paymentTransactions);
                deferred.resolve();
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;
        }
        function getPaymentTransactionStatus4Interswitch(id) {
            var deferred = $q.defer();
            $http.get('api/PaymentController/GetPaymentTransactionStatus4Interswitch?id='+id).then(function (result) {
                //successful call
             

                if (result.data.id != null) {

                    for (var i = 0; i < _paymentTransactions.length; i++) {

                        if (_paymentTransactions[i].id == result.data.id) {
                            _paymentTransactions.splice(_paymentTransactions.indexOf(_paymentTransactions[i]), 1);

                        }
                    }
                }
                deferred.resolve(_paymentTransactions);
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;
        }
        

        function getPaymentTransactionDetails(paymentTransactionID) {
            var deferred = $q.defer();
            $http({
                method: 'get',
                url: "api/PaymentController/GetPaymentTransactionByID",
                params: { PaymentTransactionID: paymentTransactionID }
            })
            .then(function (result) {
                //successful call
                angular.copy(result.data, _paymentTransactionDetails);
                deferred.resolve();
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;
        }

        function getAllOfferingTransactions() {
            var deferred = $q.defer();
            $http.get('api/AccountingFinancialController/GetFinancialOfferingContributionTransactions').then(function (result) {
                //successful call
                angular.copy(result.data, _allOfferingTransactions);

                deferred.resolve();
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;

        }

        function validateChurchHostName(host) {
            var deferred = $q.defer();
            $http.get('api/SettingsController/ValidateChurchHostName?host='+host).then(function (result) {
                //successful call
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;

        }

        function loadChurchBankData() {
            var deferred = $q.defer();
            $http.get('api/churchprofileController/getChurchInfo')
            .then(function (result) {
                //successful call
                angular.copy(result.data, _churchBankDetails);
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;

        }


        function saveChurchBankDetails(BankDetails) {
            var deferred = $q.defer();
            //api/churchprofileController/saveBankDetails
            $http.post('api/SettingsController/saveBankDetails', BankDetails)
            .then(function (result) {
                //successful call
                //should return the bank details
                angular.copy(result.data, _churchBankDetails);
                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });

            return deferred.promise;

        }

    }
})();