﻿(function () {
    'use strict';

    var controllerId = 'onlineGivingSettingsController';

    // TODO: replace app with your module name
    angular.module('churchplusapp').controller(controllerId, ['$scope', 'onlineGivingDataServices', 'dataservices', onlineGivingSettingsController]);

    function onlineGivingSettingsController($scope, onlineGivingDataServices, dataservices) {

        $scope.SavedBankDetails = onlineGivingDataServices.ChurchBankDetailsData;

        $(".churchAlias").focusin(function () {
            $("#AliasValidationMsg").html("");
            $('#validateCheckMark').html("");
        });


        //To Validate Numeric input only
        $("#bankAccountNumber").keydown(function (e) {
            // Allow: backspace, delete, tab, escape, enter and .
            if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) !== -1 ||
                // Allow: Ctrl+A
                (e.keyCode == 65 && e.ctrlKey === true) ||
                // Allow: Ctrl+C
                (e.keyCode == 67 && e.ctrlKey === true) ||
                // Allow: Ctrl+X
                (e.keyCode == 88 && e.ctrlKey === true) ||
                // Allow: home, end, left, right
                (e.keyCode >= 35 && e.keyCode <= 39)) {
                // let it happen, don't do anything
                return;
            }
            // Ensure that it is a number and stop the keypress
            if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                e.preventDefault();
            }
            var ok = /^\d*\.?\d{0,2}$/.test('#BankAccountNumber');
            console.log(ok);

        });



        //load church bank data on online giving settings page visitation
        onlineGivingDataServices.loadChurchBankData()
        .then(function (result) {
            //success
        },
        function () {
            //error
        });


        $scope.validateChurchAlias = function (host)
        {
            //ensure payment alias is not an empty string before validating
            if(host != "" & host != null){

                 onlineGivingDataServices.validateChurchHostName(host)
                .then(function (result) {
                    //success
                    if (result == "true") {
                        $('#AliasValidationMsg').html("<span style='color:#428bca'>Available</span>");
                        $('#validateCheckMark').html('<i class="icon-checkmark3" style="color:#428bca"></i>')
                    }
                    else {
                        $('#AliasValidationMsg').html("<span style='color:#d65c4f'>Unavailable</span>");
                        $('#validateCheckMark').html("");
                    }
                },
                 function () {
                     //failure
                     //alert('something went wrong!');
                 });


            }

        }

        $scope.ValidateBankAndSave = function(){

            SaveBank($scope.Bank);
        }

        var SaveBank = function (BankDetails)
        {
            console.log(BankDetails);
            onlineGivingDataServices.saveChurchBankDetails(BankDetails)
            .then(function (result) {
                //success
            },
             function () {
                 //failure
             });
        }

    }

})();


