﻿(function () {
    'use strict';

    var controllerId = 'phonenumbergroupscontroller';
    churchplusapp.controller(controllerId, ['$scope', 'communicationDataServices', 'notificationFactory', phonenumbergroupscontroller]);

    function phonenumbergroupscontroller($scope, communicationDataServices, notificationFactory) {
        $scope.title = 'phonenumbergroupscontroller';
        $scope.phonenumbergroups = communicationDataServices.phoneNumberGroups;

        communicationDataServices.getPhoneNumberGroupsData().then(function (result) { }, function () { })

        ////////////////////////     refresh the list of phone number groups   /////////////////////////////////        

        $scope.Refresh = function () {
            communicationDataServices.getPhoneNumberGroupsData().then(function (result) { },
                function () {
                    //Error refreshing data set
                    notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
                });
        }

        ////////////////////////     Delete phone number groups   /////////////////////////////////

        function getSelectedPhoneNumberGroups() {
            var phoneNumberGroupsArray = [];
            for (var i = 0; i < $scope.phonenumbergroups.length; i++) {

                if ($scope.phonenumbergroups[i].isSelected == true) {
                    var phoneNumberGroup = {};

                    phoneNumberGroup.id = $scope.phonenumbergroups[i].id;
                    phoneNumberGroup.text = $scope.phonenumbergroups[i].text;
                    phoneNumberGroup.message = $scope.phonenumbergroups[i].message;
                    phoneNumberGroup.date = $scope.phonenumbergroups[i].date;
                    phoneNumberGroupsArray.push(phoneNumberGroup);
                }
            }

            return phoneNumberGroupsArray;
        }

        $scope.Delete = function () {

            if (getSelectedPhoneNumberGroups().length < 1) {
                notificationFactory.error('Please select Draft to delete');
            }
            else {
                //make a call to the delete service pass the array of messages

                var selectedPhoneNumberGroup = getSelectedPhoneNumberGroups();

                communicationDataServices.removePhoneNumberGroupData(selectedPhoneNumberGroup)
                    .then(function (result) {

                        notificationFactory.success('phone number group Deleted');

                    },
                 function () {

                     notificationFactory.error('Delete not successful, please check the internet and try again.');

                 });
            }

        }

       
    }
})();
