﻿(function () {
    'use strict';

    var controllerId = 'prayerPointsController';
    churchplusapp.controller(controllerId, ['$scope', '$window', 'prayerDataServices', 'notificationFactory', '$filter', 'ngTableParams', prayerPointsController]);

    function prayerPointsController($scope, $window, prayerDataServices, notificationFactory, $filter, ngTableParams) {
        $scope.title = 'prayerPointsController';
        $scope.data = prayerDataServices;

        /////////////////// function to hide url

        $scope.Goto = function (url) {
            $window.location = url;
        }

        /////////////////// function to hide url


        ///////////////// loading prayer points

        if (prayerDataServices.IsPrayerPointsDataInitialized() == false) {
            prayerDataServices.getPrayerPointsData()
               .then(function () {
                   ngTableFunction();
               }, function () { alert("something is wrong") });
        }
        else {
            ngTableFunction();
        }
        ///////////////// loading prayer points end

        /////////////// ngTable
        function ngTableFunction() {
            $scope.tableParams = new ngTableParams({
                page: 1,            // show first page
                count: 10,          // count per page
                sorting: {
                    name: 'asc'     // initial sorting
                }
            }, {
                total: $scope.data.prayerPoints.length, // length of data
                getData: function ($defer, params) {
                    // use build-in angular filter
                    var orderedData = params.sorting() ? $filter('orderBy')($scope.data.prayerPoints, params.orderBy()) : $scope.data.prayerPoints;

                    $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
                }
            });
        }

        /////////////// ngTable end

        //////////////function for refreshing prayer points

        $scope.Refresh = function () {
            prayerDataServices.getPrayerPointsData().then(
                    function () {
                        ///success
                    },
                    function () {
                        //Error refreshing data set
                        notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
                    });
        }

        /////////////function for refreshing prayer points end

        //////////// function for deleting prayer points

        $scope.Remove = function (ID) {
            prayerDataServices.removePrayerPointData(ID).then(function (p) {
                notificationFactory.success('Prayer Point removed');
            }, function (p) {
                notificationFactory.error(p);
            });
        }

        $scope.ConfirmDelete = function (ID) {
            if (confirm("Are you sure to want to Delete?") == true) {
                $scope.Remove(ID)
            }

        }

        //////////// function for deleting prayer points end
        
    }
})();
