﻿(function () {
    'use strict';

    var controllerId = 'prayerRequestNewEditController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', '$window', '$routeParams', 'prayerDataServices', 'notificationFactory', prayerRequestNewEditController]);

    function prayerRequestNewEditController($scope, $window, $routeParams, prayerDataServices, notificationFactory) {
        $scope.title = 'prayerRequestNewEditController';

        $scope.prayerRequest = {};

        if ($routeParams.id != null) {
            prayerDataServices.getPrayerRequestDataForEdit($routeParams.id).then(function (prayerRequest) {

                $scope.prayerRequest = prayerRequest;

            }, function () {
                //Use Toaster Alert Note
                notificationFactory.error("Getting the prayer Information, try again");

            })

        }



        $scope.Save = function () {           
            prayerDataServices.addPrayerRequestData($scope.prayerRequest).then(function (result) {
                $window.location = "#/PrayerRequests";
                
            }, function () {
                notificationFactory.error("Unsuccessful Operation");

            });
        }

        $scope.Cancel = function () {
            $scope.prayerRequest = {};

        }

        $(".datepicker").datepicker({
            showOtherMonths: true
        });




    }
})();
