﻿(function () {
    'use strict';


    var controllerId = 'prayerRequestsController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId, ['$scope', '$window', 'prayerDataServices', 'notificationFactory', '$filter', 'ngTableParams', prayerRequestsController]);


    function prayerRequestsController($scope, $window, prayerDataServices, notificationFactory, $filter, ngTableParams) {
        $scope.title = 'prayerRequestsController';

        $scope.data = prayerDataServices;

        $scope.Goto = function (url) {
            $window.location = url;
        }     
       
       

        //Load prayers
        
        if (prayerDataServices.IsPrayerRequestsDataInitialized() == false) {
            prayerDataServices.getPrayerRequestsData()
               .then(function () {
                   ngTableFunction2();
               }, function () { alert("something is wrong") });
        }
        else {
            ngTableFunction2();
        }


        //////ngtable     
        
        function ngTableFunction2() {
            $scope.tableParams = new ngTableParams({
                page: 1,            // show first page
                count: 10,          // count per page
                sorting: {
                    name: 'asc'     // initial sorting
                }
            }, {
                total: $scope.data.prayerRequests.length, // length of data
                getData: function ($defer, params) {
                    // use build-in angular filter
                    var orderedData = params.sorting() ? $filter('orderBy')($scope.data.prayerRequests, params.orderBy()) : $scope.data.prayerRequests;

                    $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
                }
            });
        }
       

        ////refresh prayer points
        $scope.Refresh = function () {            
                prayerDataServices.getPrayerRequestsData().then(function () { },
                    function () {
                        //Error refreshing data set
                        notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
                    });
                }

        ////remove prayer
        $scope.Remove = function (ID) {           
                prayerDataServices.removePrayerRequestData(ID).then(function (pr) {
                    notificationFactory.success('Prayer Request removed');
                }, function (p) {
                    notificationFactory.error(pr);
                });
            }

        $scope.ConfirmDelete = function (ID) {
            if (confirm("Are you sure to want to Delete?") == true) {
                $scope.Remove(ID)
            }

        }

        
    }
})();
