﻿(function () {
    'use strict';

    var controllerId = 'scheduleEmailMessageNewEditController';

    // TODO: replace app with your module name   
    churchplusapp.controller(controllerId, ['$scope', '$location', '$routeParams', '$timeout', 'dataservices', '$window', 'notificationFactory', 'scheduledMessageDataServices', scheduleEmailMessageNewEditController]);

    function scheduleEmailMessageNewEditController($scope, $location, $routeParams, $timeout, dataservices, $window, notificationFactory, scheduledMessageDataServices) {
        $scope.title = 'scheduleEmailMessageNewEditController';


        $timeout(function () {

            $('#select-individual-contact')
        .select2({
            placeholder: 'Select person from membership database',
            multiple: true,
            minimumInputLength: 3,
            query: function (query) {
                dataservices.getPersonSearch(query.term).then(function (data) {

                    query.callback({ results: data });

                    // return data;
                }, function () { });
            },
            width: "100%"
        }
        );

        }, 100);

        //This method checks if the data has been initialized and resure it 
        if (dataservices.IsCommunicationLookUpDataInitialized() == false) {

            dataservices.getCommunicationGroupedData().then(function (data) {


                BindCommunicationLookUp(data);


            }, function () { });


        } else {
            var result = dataservices.communicationLookUpData;
            BindCommunicationLookUp(result)
        }


        function BindCommunicationLookUp(result) {
            $('#select-grouped-contacts').select2({ width: "100%", placeholder: 'Select Grouped Contacts From Database', });

            //clear all the contents of the select.
            //Membershi Data
            var $membershipgroup = $();
            $membershipgroup = $('<optgroup />', { label: 'MEMBERSHIP CATEGORY' }).appendTo('#select-grouped-contacts');
            $membershipgroup.append($('<option />', {
                text: 'All Contacts',
                value: 'membership_00000000-0000-0000-0000-000000000000'
            }));
            for (var i = 0; i < result.membership.length; i++) {

                $membershipgroup.append($('<option />', {
                    text: result.membership[i].text,
                    value: 'membership_' + result.membership[i].id
                }));
            }

            //This is for Age Category data
            var $AgeGroup = $();
            $AgeGroup = $('<optgroup />', { label: 'AGE-GROUP CATEGORY' }).appendTo('#select-grouped-contacts');
            for (var i = 0; i < result.age.length; i++) {

                $AgeGroup.append($('<option />', {
                    text: result.age[i].text + ' (Years)',
                    value: 'age_' + result.age[i].id
                }));
            }

            //This is for Marital Status Category databinding
            var $MaritalStatusGroup = $();
            $MaritalStatusGroup = $('<optgroup />', { label: 'MARITAL STATUS CATEGORY' }).appendTo('#select-grouped-contacts');
            for (var i = 0; i < result.marital.length; i++) {

                $MaritalStatusGroup.append($('<option />', {
                    text: result.marital[i].text,
                    value: 'marital_' + result.marital[i].id
                }));
            }

            //This is for Gender Category databinding
            var $GenderGroup = $();
            $GenderGroup = $('<optgroup />', { label: 'GENDER CATEGORY' }).appendTo('#select-grouped-contacts');
            for (var i = 0; i < result.gender.length; i++) {

                $GenderGroup.append($('<option />', {
                    text: result.gender[i].text,
                    value: 'gender_' + result.gender[i].id
                }));
            }

            //This is for Groups databinding
            var $Groupspgroup = $();
            $Groupspgroup = $('<optgroup />', { label: 'GROUPS CATEGORY' }).appendTo('#select-grouped-contacts');
            $Groupspgroup.append($('<option />', {
                text: 'All Members In Groups',
                value: 'group_00000000-0000-0000-0000-000000000000'
            }));
            for (var i = 0; i < result.group.length; i++) {

                $Groupspgroup.append($('<option />', {
                    text: result.group[i].name,
                    value: 'group_' + result.group[i].id
                }));
            }

            //This is for House Fellowship Bind To Select
            var $HouseFellowshipGroup = $();
            $HouseFellowshipGroup = $('<optgroup />', { label: 'HOUSE FELLOWSHIP CATEGORY' }).appendTo('#select-grouped-contacts');
            $HouseFellowshipGroup.append($('<option />', {
                text: 'All Members In House Fellowship',
                value: 'house_00000000-0000-0000-0000-000000000000'
            }));
            for (var i = 0; i < result.house.length; i++) {

                $HouseFellowshipGroup.append($('<option />', {
                    text: result.house[i].name,
                    value: 'house_' + result.house[i].id
                }));
            }
            $('#select-grouped-contacts').select2({ width: "100%", placeholder: 'Select Grouped Contacts From Database', });


        }


        $scope.scheduledMessage = {};

        if ($routeParams.id != null) {
            scheduledMessageDataServices.getScheduledMessagesDataForEdit($routeParams.id).then(function (scheduledMessage) {

                $scope.scheduledMessage = scheduledMessage;
                $('#spinner-time').val(scheduledMessage.time);

            }, function () {
                //Use Toaster Alert Note
                notificationFactory.error("Getting the announcement Information, try again");

            })

        }
        $scope.Save = function () {
            $scope.scheduledMessage.groupedContacts = $('#select-grouped-contacts').val();
            $scope.scheduledMessage.ToContacts = $('#select-individual-contact').val();            
            $scope.scheduledMessage.messageType = "Email";
            $scope.scheduledMessage.time = $('#spinner-time').val();
            scheduledMessageDataServices.addScheduledMessageData($scope.scheduledMessage).then(function (result) {
                $window.location = "#/ScheduleMessages";

            }, function () {
                notificationFactory.error("Unsuccessful Operation");

            });
        }

        $scope.Cancel = function () {
            $scope.scheduledMessage = {};

        }



        $(".datepicker").datepicker({
            showOtherMonths: true
        });

        $("#spinner-time").timespinner();

    }
})();