﻿(function () {
    'use strict';

    var controllerId = 'scheduleMessageController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId, ['$scope', '$window', '$filter', 'ngTableParams', 'scheduledMessageDataServices', 'notificationFactory', scheduleMessageController]);

    function scheduleMessageController($scope, $window, $filter, ngTableParams, scheduledMessageDataServices, notificationFactory) {
        $scope.title = 'scheduleMessageController';  
          
        $scope.scheduledMessages = scheduledMessageDataServices.scheduledMessages;

        //Load scheduledMessages
        if (scheduledMessageDataServices.isScheduledMessagesDataInitialized() == false) {
            scheduledMessageDataServices.getScheduledMessagesData().then(function () {
                //success         
                ngTableFunction();
            },
         function () {
             //failure
             alert('Something wrong just happened');
         });
        }
        else {
            ngTableFunction();
        }

        //////ng-table tins
        function ngTableFunction() {
            $scope.tableParams = new ngTableParams({
                page: 1,            // show first page
                count: 10,          // count per page
                sorting: {
                    name: 'asc'     // initial sorting
                }
            }, {
                total: $scope.scheduledMessages.length, // length of data
                getData: function ($defer, params) {
                    // use build-in angular filter
                    var orderedData = params.sorting() ?
                        $filter('orderBy')($scope.scheduledMessages, params.orderBy()) :
                        $scope.scheduledMessages;
                    $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
                }
            });

        }

        //function for conditional routing based on messagetype

        $scope.GoToSpecfiedRoute = function (schedulemessage) {
            if (schedulemessage.messageType == "SMS")
            {
                $window.location = "#/ScheduleMessages/EditSMSMessage/" + schedulemessage.id;
            }
            else if (schedulemessage.messageType == "Email")
            {
                $window.location = "#/ScheduleMessages/EditEmailMessage/" + schedulemessage.id;
            }
        }


        //refresh scheduledMessages
        $scope.Refresh = function () {

            scheduledMessageDataServices.getScheduledMessagesData().then(function () { },
                function () {
                    //Error refreshing data set
                    notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
                });

        }

        //remove scheduledMessage
        $scope.Remove = function (scheduledMessageID) {
            scheduledMessageDataServices.removeScheduledMessageData(scheduledMessageID).then(function (a) {
                notificationFactory.success('scheduled Message removed');
            }, function (a) {
                notificationFactory.error(a);
            });

        }

        $scope.ConfirmDelete = function (scheduledMessageID) {
            if (confirm("Are you sure to want to Delete?") == true) {
                $scope.Remove(scheduledMessageID)
            }


        }

       

    }
})();
