﻿(function () {
    'use strict';
    var serviceId = 'scheduledMessageDataServices';

    // TODO: replace app with your module name
    churchplusapp.factory(serviceId, ['$http', '$q', scheduledMessageDataServices]);

    function scheduledMessageDataServices($http, $q) {
        // Define the functions and properties to reveal.

        var _scheduledMessages = [];

        var _initScheduledMessages = false;

        var service = {

            scheduledMessages: _scheduledMessages,
            getScheduledMessagesData: getScheduledMessagesData,
            addScheduledMessageData: addScheduledMessageData,
            removeScheduledMessageData: removeScheduledMessageData,
            isScheduledMessagesDataInitialized: isScheduledMessagesDataInitialized,
            getScheduledMessagesDataForEdit: getScheduledMessagesDataForEdit           
        };

        return service;


        //function for getting all the scheduled messages

        function getScheduledMessagesData() {
            var deferred = $q.defer();

            $http.get('api/CommunicationController/GetScheduledMessages').then(function (result) {
                //successful call
                angular.copy(result.data, _scheduledMessages);
                _initScheduledMessages = true;

                deferred.resolve();
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        //function for add an announcement

        function addScheduledMessageData(scheduledMessageData) {
            var deferred = $q.defer();

            var scheduledMessageDataToEdit;
            if (scheduledMessageData.id != null) {
                scheduledMessageDataToEdit = scheduledMessageData;
            }
            $http.post('api/CommunicationController/SaveScheduledMessage', scheduledMessageData).then(function (result) {

                if (scheduledMessageDataToEdit != null) {
                    for (var i = 0; _scheduledMessages.length > i; i++) {
                        if (_scheduledMessages[i].id === scheduledMessageData.id) {
                            //console.log(i);
                            _scheduledMessages.splice(i, 1, result.data);
                            break;
                        }
                    }


                } else {
                    _scheduledMessages.splice(0, 0, result.data);

                }

                deferred.resolve(result.data);

            }, function (result) {

                deferred.reject(result.data);
            });

            return deferred.promise;

        }


        function getScheduledMessagesDataForEdit(id) {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/CommunicationController/GetScheduledMessage',
                params: { id: id }
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;

        }


        function removeScheduledMessageData(scheduledMessageID) {
            var deferred = $q.defer();

            $http({
                method: 'delete',
                url: 'api/CommunicationController/DeleteScheduledMessage',
                params: { ID: scheduledMessageID }
            })
                .then(function (result) {
                    for (var i = 0; _scheduledMessages.length > i; i++) {
                        if (_scheduledMessages[i].id === scheduledMessageID) {
                            _scheduledMessages.splice(_scheduledMessages.indexOf(_scheduledMessages[i]), 1);
                            break;
                        }

                    }
                    deferred.resolve(result.data);
                },
            function () {
                deferred.reject();
            });

            return deferred.promise;

        }


        function isScheduledMessagesDataInitialized() {

            return _initScheduledMessages;
        }


    }

})();
