﻿(function () {
    'use strict';

    var controllerId = 'sentemailcontroller';

    // TODO: replace app with your module name
   
    churchplusapp.controller(controllerId, ['$scope', 'communicationDataServices', 'notificationFactory', '$filter', 'ngTableParams', sentemailcontroller]);

    function sentemailcontroller($scope, communicationDataServices, notificationFactory,$filter, ngTableParams) {
        $scope.title = 'sentemailcontroller';
        $scope.sentEmails = communicationDataServices.sentEmails;
        $scope.sentEmails.isSelected = false;
       

        ////////////////////////   Initialize the list of sent emails   /////////////////////////////////

        if (communicationDataServices.isSentEmailDataInitialized() == false) {

            communicationDataServices.getSentEmailData().then(function () {
                //success  
                ngTableFunction();
                },
         function () {
             //failure
             alert('Something wrong just happened');
         });
        }

        /////////////// ngTable
        function ngTableFunction() {
            $scope.tableParams = new ngTableParams({
                page: 1,            // show first page
                count: 10,          // count per page
                sorting: {
                    dateSent: 'desc'     // initial sorting
                }
            }, {
                total: $scope.sentEmails.length, // length of data
                getData: function ($defer, params) {
                    // use build-in angular filter
                    var orderedData = params.sorting() ? $filter('orderBy')($scope.sentEmails, params.orderBy()) : $scope.sentEmails;

                    $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
                }
            });
        }


        ////////////////////////     refresh the list of sent email   /////////////////////////////////

        $scope.Refresh = function () {
            communicationDataServices.getSentEmailData().then(function () { },
                function () {
                    //Error refreshing data set
                    notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
                });
        }


        ////////////////////////     Delete sent email   /////////////////////////////////        

        function getSelectedMessages() {
            var messagesArray = [];
            for (var i = 0; i < $scope.sentEmails.length; i++) {

                if ($scope.sentEmails[i].isSelected == true) {
                    var sentMessage = {};

                    sentMessage.id = $scope.sentEmails[i].id;
                    sentMessage.text = $scope.sentEmails[i].text;
                    sentMessage.message = $scope.sentEmails[i].message;
                    sentMessage.date = $scope.sentEmails[i].date;
                    messagesArray.push(sentMessage);
                }
            }

            return messagesArray;
        }

        $scope.Delete = function () {

            if (getSelectedMessages().length < 1) {
                notificationFactory.error('Please select message to delete');
            }
            else {
                //make a call to the delete service pass the array of messages
                var selectedMessages = getSelectedMessages();

                communicationDataServices.removeSentEmailData(selectedMessages)
                    .then(function (result) {

                        notificationFactory.success('Message Deleted');

                    },
                 function () {

                     notificationFactory.error('Delete not successful, please check the internet and try again.');

                 });
            }

        }
    }
})();
