﻿(function () {
    'use strict';

    var controllerId = 'sentsmscontroller';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId, ['$scope', 'communicationDataServices', '$filter', 'ngTableParams', sentsmscontroller]);

    function sentsmscontroller($scope, communicationDataServices, $filter, ngTableParams) {
        $scope.title = 'sentsmscontroller';
        $scope.sentSms = communicationDataServices.sentSms;
        communicationDataServices.getSMSBalance().then(function (result) {

            $scope.smsBalance = result;
        }, function () { });


        ////////////////////////   Initialize the list of sent Sms   /////////////////////////////////

        if (communicationDataServices.isSentSmsDataInitialized() == false) {
            communicationDataServices.getSentSmsData().then(function () {
                //success  
                ngTableFunction();
            },
         function () {
             //failure
             alert('Something wrong just happened');
         });
        }

        /////////////// ngTable
        function ngTableFunction() {
            $scope.tableParams = new ngTableParams({
                page: 1,            // show first page
                count: 10,          // count per page
                sorting: {
                    dateSent: 'desc'     // initial sorting
                }
            }, {
                total: $scope.sentSms.length, // length of data
                getData: function ($defer, params) {
                    // use build-in angular filter
                    var orderedData = params.sorting() ? $filter('orderBy')($scope.sentSms, params.orderBy()) : $scope.sentSms;

                    $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
                }
            });
        }


        ////////////////////////     refresh the list of sent Sms   /////////////////////////////////

        $scope.Refresh = function () {
            communicationDataServices.getSentSmsData().then(function () { },
                function () {
                    //Error refreshing data set
                    notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
                });
        }


        ////////////////////////     Delete sent Sms   /////////////////////////////////      


        function getSelectedMessages() {
            var messagesArray = [];
            for (var i = 0; i < $scope.sentSms.length; i++) {

                if ($scope.sentSms[i].isSelected == true) {
                    var SMSMessage = {};

                    SMSMessage.id = $scope.sentSms[i].id;
                    SMSMessage.text = $scope.sentSms[i].text;
                    SMSMessage.message = $scope.sentSms[i].message;
                    SMSMessage.date = $scope.sentSms[i].date;
                    messagesArray.push(SMSMessage);
                }
            }

            return messagesArray;
        }

        $scope.Delete = function () {

            if (getSelectedMessages().length < 1) {
                notificationFactory.error('Please select Draft to delete');
            }
            else {
                //make a call to the delete service pass the array of messages

                var selectedMessages = getSelectedMessages();

                communicationDataServices.removeSentSmsData(selectedMessages)
                    .then(function (result) {

                        notificationFactory.success('drafts Deleted');

                    },
                 function () {

                     notificationFactory.error('Delete not successful, please check the internet and try again.');

                 });
            }

        }


    }
})();
