﻿(function () {
    'use strict';

    var serviceId = 'settingDataServices';

    // TODO: replace app with your module name
    churchplusapp.factory(serviceId, ['$http', '$q', settingDataServices]);

    function settingDataServices($http, $q) {
        // Define the functions and properties to reveal.

        /// Attendance Category Setting Variables
        var _attendanceCategorySettingData = [];
        var _initAttendanceCategorySettingData = false;

        /// Age Group Category Setting Variables
        var _ageGroupCategorySettingData = [];
        var _initAgeGroupCategorySettingData = false;


        /// FollowUp Status Setting Variables
        var _followUpStatusSettingData = [];
        var _initFollowUpStatusSettingData = false;

        /// Membership Category Setting Variables
        var _membershipCategorySettingData = [];
        var _initMembershipCategorySettingData = false;

        // Default Messages Setting Variables
        var _defaultMessages = [];
        var _MessageTypes = [];
        var _MessageCategories = [];
        var _initDefaultMessagesData = false;



        var service = {

            /// Attendance Category Setting
            attendanceCategorySettingData: _attendanceCategorySettingData,
            getAllAttendanceCategorySettingData: getAllAttendanceCategorySettingData,
            saveAttendanceCategorySettingData: saveAttendanceCategorySettingData,
            deleteAttendanceCategorySettingData: deleteAttendanceCategorySettingData,
            isAttendanceCategorySettingDataInitialized: isAttendanceCategorySettingDataInitialized,


            /// Age Group Category Setting
            ageGroupCategorySettingData: _ageGroupCategorySettingData,
            getAllAgeGroupCategorySettingData: getAllAgeGroupCategorySettingData,
            saveAgeGroupCategorySettingData: saveAgeGroupCategorySettingData,
            deleteAgeGroupCategorySettingData: deleteAgeGroupCategorySettingData,
            isAgeGroupCategorySettingDataInitialized: isAgeGroupCategorySettingDataInitialized,

            /// Follow Up Category Setting
            followUpStatusSettingData: _followUpStatusSettingData,
            getAllFollowUpStatusSettingData: getAllFollowUpStatusSettingData,
            saveFollowUpStatusSettingData: saveFollowUpStatusSettingData,
            deleteFollowUpStatusSettingData: deleteFollowUpStatusSettingData,
            isFollowUpStatusSettingDataInitialized: isFollowUpStatusSettingDataInitialized,


            /// Membership Category Setting
            membershipCategorySettingData: _membershipCategorySettingData,
            getAllMembershipCategorySettingData: getAllMembershipCategorySettingData,
            saveMembershipCategorySettingData: saveMembershipCategorySettingData,
            deleteMembershipCategorySettingData: deleteMembershipCategorySettingData,
            isMembershipCategorySettingDataInitialized: isMembershipCategorySettingDataInitialized,

            // Default Messages Category Setting            
            defaultMessages: _defaultMessages,            
            getAllDefaultMessagesData: getAllDefaultMessagesData,
            getDefaultMessageDataForEdit:getDefaultMessageDataForEdit,
            saveDefaultMessageData: saveDefaultMessageData,
            deleteDefaultMessageData: deleteDefaultMessageData,
            isDefaultMessageDataInitialized: isDefaultMessageDataInitialized,

            //Default Messages Type
            MessageTypes: _MessageTypes,
            getAllMessageTypes: getAllMessageTypes,

            //Default Messages Type
            MessageCategories: _MessageCategories,
            getAllMessageCategories: getAllMessageCategories
        };

        return service;

        /////////////////// FOR ATTENDANCE CATEGORY //////////////////

        //Get All Data.
        function getAllAttendanceCategorySettingData() {

            var deferred = $q.defer();
            if (_initAttendanceCategorySettingData == false) {
                $http.get("api/SettingsController/getAttendanceCategory")
                    .then(function (result) {
                        //successful call
                        angular.copy(result.data, _attendanceCategorySettingData);

                        _initAttendanceCategorySettingData = true;

                        deferred.resolve();
                    },
                function () {
                    //error in call
                    deferred.reject();
                });
            } else {
                deferred.resolve();

            }
            return deferred.promise;
        }

        //Save Data.
        function saveAttendanceCategorySettingData(dataToSave) {

            var deferred = $q.defer();

            $http.post("api/SettingsController/saveAttendanceCategory", dataToSave)
                .then(function (result) {

                    if (dataToSave.id != null) {

                        for (var i = 0; _attendanceCategorySettingData.length > i; i++) {
                            if (_attendanceCategorySettingData.id === dataToSave.id) {
                                _attendanceCategorySettingData.splice(i, 1, result.data);
                                break;
                            }
                        }

                    } else
                        _attendanceCategorySettingData.splice(0, 0, result.data);

                    deferred.resolve(result.data);

                }, function (result) {

                    deferred.reject(result.data);
                });

            return deferred.promise;

        }

        //Delete Single Data.
        function deleteAttendanceCategorySettingData(dataID) {
            var deferred = $q.defer();
            $http({
                method: 'delete',
                url: "api/SettingsController/deleteAttendanceCategory",
                params: { id: dataID }
            })
                .then(function (result) {

                    //remove the deleted item from the local dataset
                    for (var i = 0; _attendanceCategorySettingData.length > i; i++) {

                        if (_attendanceCategorySettingData[i].id == result.data.id) {
                            _attendanceCategorySettingData.splice(i, 1);
                            break;
                        }
                    }

                    deferred.resolve(result.data);

                }, function (result) {
                    // At Error
                    deferred.reject(result.data);
                });

            return deferred.promise;
        }

        // Initialization check...
        function isAttendanceCategorySettingDataInitialized() {
            return _initAttendanceCategorySettingData;
        }

        /////////////////// FOR AGE GROUP CATEGORY //////////////////

        //Get All Data.
        function getAllAgeGroupCategorySettingData() {

            var deferred = $q.defer();
            if (_initAgeGroupCategorySettingData == false) {
                $http.get('api/SettingsController/getAgeGroupCategory')
                    .then(function (result) {
                        //successful call
                        angular.copy(result.data, _ageGroupCategorySettingData);

                        _initAgeGroupCategorySettingData = true;

                        deferred.resolve();
                    },
                function () {
                    //error in call
                    deferred.reject();
                });
            } else {
                deferred.resolve();

            }
            return deferred.promise;
        }

        //Save Data.
        function saveAgeGroupCategorySettingData(dataToSave) {

            var deferred = $q.defer();

            $http.post("api/SettingsController/saveAgeGroupCategory", dataToSave)
                .then(function (result) {

                    if (dataToSave.id != null) {

                        for (var i = 0; _ageGroupCategorySettingData.length > i; i++) {
                            if (_ageGroupCategorySettingData.id === dataToSave.id) {
                                _ageGroupCategorySettingData.splice(i, 1, result.data);
                                break;
                            }
                        }

                    } else
                        _ageGroupCategorySettingData.splice(0, 0, result.data);


                    deferred.resolve(result.data);

                }, function (result) {

                    deferred.reject(result.data);
                });

            return deferred.promise;

        }

        //Delete Single Data.
        function deleteAgeGroupCategorySettingData(dataID) {
            var deferred = $q.defer();
            $http({
                method: 'delete',
                url: "api/SettingsController/deleteAgeGroupCategory",
                params: { id: dataID }
            })
                .then(function (result) {

                    //remove the deleted item from the local dataset
                    for (var i = 0; _ageGroupCategorySettingData.length > i; i++) {

                        if (_ageGroupCategorySettingData[i].id === result.data.id) {
                            _ageGroupCategorySettingData.splice(i, 1);
                            break;
                        }
                    }
                    deferred.resolve(result.data);

                }, function (result) {
                    // At Error
                    deferred.reject(result.data);
                });

            return deferred.promise;
        }

        // Initialization check...
        function isAgeGroupCategorySettingDataInitialized() {
            return _initAgeGroupCategorySettingData;
        }

        /////////////////// FOR FOLLOW-UP STATUS //////////////////

        //Get All Data.
        function getAllFollowUpStatusSettingData() {

            var deferred = $q.defer();
            if (_initFollowUpStatusSettingData == false) {
                $http.get("api/SettingsController/getFollowUpStatus")
                    .then(function (result) {
                        //successful call
                        angular.copy(result.data, _followUpStatusSettingData);

                        _initFollowUpStatusSettingData = true;

                        deferred.resolve();
                    },
                function () {
                    //error in call
                    deferred.reject();
                });
            } else {
                deferred.resolve();

            }
            return deferred.promise;
        }

        //Save Data.
        function saveFollowUpStatusSettingData(dataToSave) {

            var deferred = $q.defer();

            $http.post("api/SettingsController/saveFollowUpStatus", dataToSave)
                .then(function (result) {

                    if (dataToSave.id != null) {

                        for (var i = 0; _followUpStatusSettingData.length > i; i++) {
                            if (_followUpStatusSettingData.id === dataToSave.id) {
                                _followUpStatusSettingData.splice(i, 1, result.data);
                                break;
                            }
                        }

                    } else
                        _followUpStatusSettingData.splice(0, 0, result.data);

                    deferred.resolve(result.data);

                }, function (result) {

                    deferred.reject(result.data);
                });

            return deferred.promise;

        }

        //Delete Single Data.
        function deleteFollowUpStatusSettingData(dataID) {
            var deferred = $q.defer();
            $http({
                method: 'delete',
                url: "api/SettingsController/deleteFollowUpStatus",
                params: { id: dataID }
            })
                .then(function (result) {

                    //remove the deleted item from the local dataset

                    for (var i = 0; _followUpStatusSettingData.length > i; i++) {

                        if (_followUpStatusSettingData[i].id == result.data.id) {
                            _followUpStatusSettingData.splice(i, 1);
                            break;
                        }
                    }
                    deferred.resolve(result.data);

                }, function (result) {
                    // At Error
                    deferred.reject(result.data);
                });

            return deferred.promise;
        }

        // Initialization check...
        function isFollowUpStatusSettingDataInitialized() {
            return _initFollowUpStatusSettingData;
        }

        /////////////////// FOR MEMBERSHIP CATEGORIES //////////////////

        //Get All Data.
        function getAllMembershipCategorySettingData() {

            var deferred = $q.defer();
            if (_initMembershipCategorySettingData == false) {
                $http.get("api/SettingsController/getMemberCategory")
                    .then(function (result) {
                        //successful call
                        angular.copy(result.data, _membershipCategorySettingData);

                        _initMembershipCategorySettingData = true;

                        deferred.resolve();
                    },
                function () {
                    //error in call
                    deferred.reject();
                });
            } else {
                deferred.resolve();

            }
            return deferred.promise;
        }

        //Save Data.
        function saveMembershipCategorySettingData(dataToSave) {

            var deferred = $q.defer();

            $http.post("api/SettingsController/saveMemberCategory", dataToSave)
                .then(function (result) {

                    if (dataToSave.id != null) {

                        for (var i = 0; _membershipCategorySettingData.length > i; i++) {
                            if (_membershipCategorySettingData.id === dataToSave.id) {
                                _membershipCategorySettingData.splice(i, 1, result.data);
                                break;
                            }
                        }

                    } else
                        _membershipCategorySettingData.splice(0, 0, result.data);

                    deferred.resolve(result.data);

                }, function (result) {

                    deferred.reject(result.data);
                });

            return deferred.promise;

        }

        //Delete Single Data.
        function deleteMembershipCategorySettingData(dataID) {
            var deferred = $q.defer();
            $http({
                method: 'delete',
                url: "api/SettingsController/deleteMemberCategory",
                params: { id: dataID }
            })
                .then(function (result) {

                    //remove the deleted item from the local dataset
                    for (var i = 0; _membershipCategorySettingData.length > i; i++) {

                        if (_membershipCategorySettingData[i].id == result.data.id) {
                            _membershipCategorySettingData.splice(i, 1);
                            break;
                        }
                    }

                    deferred.resolve(result.data);

                }, function (result) {
                    // At Error
                    deferred.reject(result.data);
                });

            return deferred.promise;
        }

        // Initialization check...
        function isMembershipCategorySettingDataInitialized() {
            return _initMembershipCategorySettingData;
        }



        /////////////////// Default Messages ////////////////////////

        function getAllMessageTypes() {
            var deferred = $q.defer();
            $http.get("api/MessagingController/getMessageTypes")
            .then(function (result) {
                angular.copy(result.data, _MessageTypes);                
                deferred.resolve();
            },
            function () {
                deferred.reject();
            });
            return deferred.promise;
        }

        function getAllMessageCategories() {
            var deferred = $q.defer();
            $http.get("api/MessagingController/getMessageCategories")
            .then(function (result) {
                angular.copy(result.data, _MessageCategories);                
                deferred.resolve();
            },
            function () {
                deferred.reject();
            });
            return deferred.promise;
        }

        function getAllDefaultMessagesData() {
            var deferred = $q.defer();
            if (_initDefaultMessagesData == false) {
                $http.get("api/MessagingController/getDefaultMessages")
                    .then(function (result) {
                        //successful call
                        angular.copy(result.data, _defaultMessages);
                        _initDefaultMessagesData = true;
                        deferred.resolve();
                    },
                function () {
                    //error in call
                    deferred.reject();
                });
            } else {
                deferred.resolve();
            }
            return deferred.promise;
        }

        function getDefaultMessageDataForEdit(id) {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/MessagingController/getSingleDefaultMessage',
                params: { id: id }
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        function saveDefaultMessageData(dataToSave) {

            var deferred = $q.defer();

            $http.post("api/MessagingController/SaveDefaultMessage", dataToSave)
                .then(function (result) {

                    if (dataToSave.id != null) {

                        for (var i = 0; _defaultMessages.length > i; i++) {
                            if (_defaultMessages.id === dataToSave.id) {
                                _defaultMessages.splice(i, 1, result.data);
                                break;
                            }
                        }

                    } else
                        _defaultMessages.splice(0, 0, result.data);

                    deferred.resolve(result.data);

                }, function (result) {

                    deferred.reject(result.data);
                });

            return deferred.promise;

        }

        function deleteDefaultMessageData(dataID) {
            var deferred = $q.defer();
            $http({
                method: 'delete',
                url: "api/MessagingController/DeleteDefaultMessage",
                params: { id: dataID }
            })
                .then(function (result) {

                    //remove the deleted item from the local dataset
                    for (var i = 0; _defaultMessages.length > i; i++) {

                        if (_defaultMessages[i].id == result.data.id) {
                            _defaultMessages.splice(i, 1);
                            break;
                        }
                    }

                    deferred.resolve(result.data);

                }, function (result) {
                    // At Error
                    deferred.reject(result.data);
                });

            return deferred.promise;
        }

        function isDefaultMessageDataInitialized() {
            return _initDefaultMessagesData;
        }
        

    }

})();



//if (dataToSave.id != null) {

//    for (var i = 0; _followUpStatusSettingData.length > i; i++) {
//        if (_followUpStatusSettingData.id === dataToSave.id) {
//            _followUpStatusSettingData.splice(i, 1, result.data);
//            break;
//        }
//    }

//} else
//    _followUpStatusSettingData.splice(0, 0, result.data);



//for (var i = 0; _ageGroupCategorySettingData.length > 1; i++) {

//    if (_ageGroupCategorySettingData[i].id == result.data.id) {
//        _ageGroupCategorySettingData.splice(i, 1);
//    }
//}


///////////////////////////////////////////////


//for (var i = 0; i < _membershipCategorySettingData.length; i++) {

//    if (_membershipCategorySettingData[i].id == result.data.id) {

//        _membershipCategorySettingData.splice(_membershipCategorySettingData.indexOf(_membershipCategorySettingData[i]), 1);
//    }
//}