﻿
(function () {
    'use strict';

    var controllerId = 'settingsController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', '$window', 'settingDataServices', 'notificationFactory', 'notificationDialog', 'dataservices', '$filter', 'ngTableParams', settingsController]);


    function settingsController($scope, $window, settingDataServices, notificationFactory, notificationDialog, dataservices, $filter, ngTableParams) {

        $scope.defaultMessages = settingDataServices.defaultMessages;
        $scope.defaultMessage = {};

        if (settingDataServices.isDefaultMessageDataInitialized() == false) {
            settingDataServices.getAllDefaultMessagesData().then(
                function () {
                    ngTableFunction();
                }
                ,function () { });
        }
        else {
            ngTableFunction();
        }

        /////////////// function for get message types 
        function getMessageTypes() {
            var options = [];
            settingDataServices.getAllMessageTypes().then(
                function (result) {
                    var data = settingDataServices.MessageTypes;
                    
                    for (var i = 0; i < data.length; i++) {
                        options.push({ id: data[i].id, text: data[i].text });
                    }
                },
                function () { });
            
            return options;
        }

        var optionsMessageType = getMessageTypes();

        /////////////// function for get message categories

        function getMessageCategories() {
            var options = [];
            settingDataServices.getAllMessageCategories().then(
                function (result) {
                    var data = settingDataServices.MessageCategories;                    
                    for (var i = 0; i < data.length; i++) {
                        options.push({ id: data[i].id, text: data[i].text });
                    }
                },
                function () { });
            
            return options;
        }

        var optionsMessageCategory = getMessageCategories();

        /////// function for view and editing a single default message

        $scope.SetEdit = function (id) {
            settingDataServices.getDefaultMessageDataForEdit(id).then(
                function (defaultMessage) {

                    var returnType = optionsMessageType[defaultMessage.messageType];
                    var returnCategory = optionsMessageCategory[defaultMessage.category];

                    $scope.defaultMessage = defaultMessage;

                    $("#typeSelect").select2("data", { id: returnType.id, text: returnType.text });
                    $("#categorySelect").select2("data", { id: returnCategory.id, text: returnCategory.text });
                }
                , function () { })            
        }

        //////ng-table tins
        function ngTableFunction() {
            $scope.tableParams = new ngTableParams({
                page: 1,            // show first page
                count: 10,          // count per page
                sorting: {
                    name: 'asc'     // initial sorting
                }
            }, {
                total: $scope.defaultMessages.length, // length of data
                getData: function ($defer, params) {
                    // use build-in angular filter
                    var orderedData = params.sorting() ? $filter('orderBy')($scope.defaultMessages, params.orderBy()) : $scope.defaultMessages;

                    $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
                }
            });

        }


        

        $scope.BootBoxConfirm = function () {
            var msg = "Do you want to delete?";

            bootbox.confirm(msg, function (result) {
                if (result) { };
            });
        };

        $scope.Save = function () {
            var category = $('#categorySelect').select2('data');            
            var type = $('#typeSelect').select2('data');

            var returnValue;
           
            for (var i = 0; i < $scope.defaultMessages.length; i++) {                

                if (($scope.defaultMessages[i].messageType == type.text) && ($scope.defaultMessages[i].category == category.text))
                {
                    returnValue = 1;                    
                    break;
                }            
              
            }

            if ($scope.defaultMessage.id)
            {
                $scope.defaultMessage.category = category.id;
                $scope.defaultMessage.messageType = type.id;
                settingDataServices.saveDefaultMessageData($scope.defaultMessage).then(function (result) {
                    $scope.defaultMessage = {};
                    $("#categorySelect").select2("val", "");
                    $("#typeSelect").select2("val", "");

                }, function () {
                    notificationFactory.error("Unsuccessful Operation");
                });
            }
            else {
                if (returnValue != 1) {
                    $scope.defaultMessage.category = category.id;
                    $scope.defaultMessage.messageType = type.id;
                    settingDataServices.saveDefaultMessageData($scope.defaultMessage).then(function (result) {
                        $scope.defaultMessage = {};
                        $("#categorySelect").select2("val", "");
                        $("#typeSelect").select2("val", "");
                        //$scope.defaultMessages = settingDataServices.defaultMessages;
                        
                    }, function () {
                        notificationFactory.error("Unsuccessful Operation");
                    });
                    
                }              
                
                else {
                    notificationFactory.error("Wrong input");
                    $scope.defaultMessage = {};
                    $("#categorySelect").select2("val", "");
                    $("#typeSelect").select2("val", "");
                }
            }

            
           
        }

 
        $scope.Cancel = function () {          
            $scope.defaultMessage = {};            
            $("#categorySelect").select2("val", "");
            $("#typeSelect").select2("val", "");            
        }


        $scope.Delete = function (defaultMessageId) {
            if (confirm('You are about to delete default message')) {

                settingDataServices.deleteDefaultMessageData(defaultMessageId).then(function (r) {
                    notificationFactory.success('Default Message removed');
                }, function (r) {
                    notificationFactory.error(r);
                });
            }
        }

       


        $('#categorySelect').select2({
            placeholder: 'Select Category',
            multiple: false,
            data: optionsMessageCategory,
            width: "100%",
            initSelection: function (element, callback) {
            }
        });

       

        $('#typeSelect').select2({
            placeholder: 'Select Type',
            multiple: false,
            data: optionsMessageType,
            width: "100%",
            initSelection: function (element, callback) {
            }
        });
    }
})();