﻿(function () {
    'use strict';
    var controllerId = 'singlephonenumbergroupcontroller';
    
    churchplusapp.controller(controllerId, ['$scope', 'communicationDataServices', '$routeParams', 'notificationFactory', '$window', singlephonenumbergroupcontroller]);

    function singlephonenumbergroupcontroller($scope, communicationDataServices, $routeParams, notificationFactory, $window) {
        $scope.title = 'singlephonenumbergroupcontroller';

        $scope.phoneNumberGroup = {};


        if ($routeParams.id != null) {
            communicationDataServices.getPhoneNumberGroupDataForEdit($routeParams.id).then(function (phoneNumberGroup) {
                $scope.phoneNumberGroup = phoneNumberGroup;
            }, function () {
                //Use Toaster Alert Note
                notificationFactory.error("Error Getting The Phone Group Contact, try again");
            });
        }


        $scope.SavePhoneNumberGroup = function () {
            communicationDataServices.addPhoneNumberGroupData($scope.phoneNumberGroup).then(function (result) {
                $window.location = "#/Communication/SMS/PhoneNumberGroups";
            }, function () {
                notificationFactory.error("Unsuccessful Operation");
            });
        }



        
    }
})();
