﻿(function () {
    'use strict';

    var controllerId = 'smscomposecontroller';

    // TODO: replace app with your module name   
    churchplusapp.controller(controllerId, ['$scope', '$location', '$routeParams', '$timeout', 'dataservices', '$window', 'notificationFactory', 'communicationDataServices', 'sharedCommunicationService', smscomposecontroller]);

    function smscomposecontroller($scope, $location, $routeParams, $timeout, dataservices, $window, notificationFactory, communicationDataServices, sharedCommunicationService) {
        $scope.title = 'smscomposecontroller';
        $scope.message = {};        
        var sender, SMSTypeVal;
       
        communicationDataServices.getSMSBalance().then(function (result) {

            $scope.smsBalance = result;
        }, function () { });

        if ($routeParams.id) {
            ///// this line gets the type of sms from the url
            sender = $location.path().split("/")[2];
            
            SMSTypeVal = sharedCommunicationService.SMSType(sender);

            SMSTypeVal.getDataByID($routeParams.id).then(
                function (message) {
                    $scope.message = message;
                    //console.log($scope.message);
                },
                function () {
                    notificationFactory.error("Getting the feedback Information, try again");
                });            
        }

        
        $timeout(function () {

            $('#select-individual-contact')
        .select2({
            placeholder: 'Select person from membership database',
            multiple: true,
            minimumInputLength: 3,
            query: function (query) {
                dataservices.getPersonSearch(query.term).then(function (data) {

                    query.callback({ results: data });

                    // return data;
                }, function () { });
            },
            width: "100%"
        }
        );

        }, 100);

        //This method checks if the data has been initialized and resure it 
        if (dataservices.IsCommunicationLookUpDataInitialized() == false) {

            dataservices.getCommunicationGroupedData().then(function (data) {


                BindCommunicationLookUp(data);


            }, function () { });


        } else {
            var result = dataservices.communicationLookUpData;
            BindCommunicationLookUp(result)
        }


        $scope.SendSMS = function () {

            //Disable 'Send Message' button upon click of button
            $("#sendMessageBtn").prop("disabled", true);

            var message = {};
            notificationFactory.info('Starting the Send SMS Operation,....................');

            $scope.message.groupedContacts = $('#select-grouped-contacts').val();
            $scope.message.ToContacts = $('#select-individual-contact').val();

            message.groupedContacts = $('#select-grouped-contacts').val();
            message.ToContacts = $('#select-individual-contact').val();
            message.toOthers = $scope.message.toOthers;

            message.subject = $scope.message.subject;
            message.message = $scope.message.message;
            //check if the user has sufficient balance an send sms 

            dataservices.checkBalanceAndSendSMS(message).then(function (result) {
                if (result.status.toString() == 'false') {
                    notificationFactory.error(result.message + '</b>' + ' Units used :' + result.unitsUsed);

                }
                else {

                    $window.location = "#/Communication/SMS";
                    notificationFactory.success('SMS sent');

                }

            }, function () {


            }).then(function () {
                //Re-Enable 'Send Message' button upon return of result
                $("#sendMessageBtn").prop("disabled", false);
            });




        }


        $scope.SaveAsDraft = function () {
            communicationDataServices.addSmsDraftData($scope.message).then(function (result) {
                $window.location = "#/Communication/SMSDrafts";

            }, function () {
                notificationFactory.error("Unsuccessful Operation");
            });
        }


        $scope.Discard = function () {
            $scope.message = {};
        }


        function BindCommunicationLookUp(result) {
            $('#select-grouped-contacts').select2({ width: "100%", placeholder: 'Select Grouped Contacts From Database', });

            //clear all the contents of the select.
            //Membershi Data
            var $membershipgroup = $();
            $membershipgroup = $('<optgroup />', { label: 'MEMBERSHIP CATEGORY' }).appendTo('#select-grouped-contacts');
            $membershipgroup.append($('<option />', {
                text: 'All Contacts',
                value: 'membership_00000000-0000-0000-0000-000000000000'
            }));
            for (var i = 0; i < result.membership.length; i++) {

                $membershipgroup.append($('<option />', {
                    text: result.membership[i].text,
                    value: 'membership_' + result.membership[i].id
                }));
            }

            //This is for Age Category data
            var $AgeGroup = $();
            $AgeGroup = $('<optgroup />', { label: 'AGE-GROUP CATEGORY' }).appendTo('#select-grouped-contacts');
            for (var i = 0; i < result.age.length; i++) {

                $AgeGroup.append($('<option />', {
                    text: result.age[i].text + ' (Years)',
                    value: 'age_' + result.age[i].id
                }));
            }

            //This is for Marital Status Category databinding
            var $MaritalStatusGroup = $();
            $MaritalStatusGroup = $('<optgroup />', { label: 'MARITAL STATUS CATEGORY' }).appendTo('#select-grouped-contacts');
            for (var i = 0; i < result.marital.length; i++) {

                $MaritalStatusGroup.append($('<option />', {
                    text: result.marital[i].text,
                    value: 'marital_' + result.marital[i].id
                }));
            }

            //This is for Gender Category databinding
            var $GenderGroup = $();
            $GenderGroup = $('<optgroup />', { label: 'GENDER CATEGORY' }).appendTo('#select-grouped-contacts');
            for (var i = 0; i < result.gender.length; i++) {

                $GenderGroup.append($('<option />', {
                    text: result.gender[i].text,
                    value: 'gender_' + result.gender[i].id
                }));
            }

            //This is for Groups databinding
            var $Groupspgroup = $();
            $Groupspgroup = $('<optgroup />', { label: 'GROUPS CATEGORY' }).appendTo('#select-grouped-contacts');
            $Groupspgroup.append($('<option />', {
                text: 'All Members In Groups',
                value: 'group_00000000-0000-0000-0000-000000000000'
            }));
            for (var i = 0; i < result.group.length; i++) {

                $Groupspgroup.append($('<option />', {
                    text: result.group[i].name,
                    value: 'group_' + result.group[i].id
                }));
            }

            //This is for Phone Number Groups databinding
            var $PhoneNumberGroup = $();
            $PhoneNumberGroup = $('<optgroup />', { label: 'PHONE NUMBER GROUPS CATEGORY' }).appendTo('#select-grouped-contacts');
       
            for (var i = 0; i < result.phoneGroup.length; i++) {

                $PhoneNumberGroup.append($('<option />', {
                    text: result.phoneGroup[i].text,
                    value: 'phoneNumberGroup_' + result.phoneGroup[i].id
                }));
            }

            //This is for House Fellowship Bind To Select
            var $HouseFellowshipGroup = $();
            $HouseFellowshipGroup = $('<optgroup />', { label: 'HOUSE FELLOWSHIP CATEGORY' }).appendTo('#select-grouped-contacts');
            $HouseFellowshipGroup.append($('<option />', {
                text: 'All Members In House Fellowship',
                value: 'house_00000000-0000-0000-0000-000000000000'
            }));
            for (var i = 0; i < result.house.length; i++) {

                $HouseFellowshipGroup.append($('<option />', {
                    text: result.house[i].name,
                    value: 'house_' + result.house[i].id
                }));
            }
            $('#select-grouped-contacts').select2({ width: "100%", placeholder: 'Select Grouped Contacts From Database', });


        }

        //function to get number of pages the new sms contains and how many characters left
        $scope.countCharacters = function () {

            var characters = $scope.message.message;
            var charactersLength = characters.length;

            var pageNumber;
            var charactersRemainder;

            //if first page -- (contains 160 characters)
            if (charactersLength <= 160) {
                $("#maxCharsError").html("");
                charactersRemainder = 160 - charactersLength;
                pageNumber = 1;
            }
            
            //if second page -- (contains 145 characters)
            else if ((charactersLength > 160) && (charactersLength <= 305)) {
                $("#maxCharsError").html("");
                pageNumber = 2;
                charactersRemainder = 305 - charactersLength;
            }
            else {
                $("#maxCharsError").html("You have entered the maximum number of characters allowed");
            }

            $('#charactersRemainder').html(charactersRemainder);
            $('#pageNumber').html(pageNumber);
        }
    }
})();
