﻿(function () {
    'use strict';

    var controllerId = 'smsdrafthomecontroller';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId, ['$scope', 'dataservices', 'communicationDataServices','$filter', 'ngTableParams', 'notificationFactory', smsdrafthomecontroller]);

    function smsdrafthomecontroller($scope, dataservices, communicationDataServices,$filter, ngTableParams, notificationFactory) {
        $scope.title = 'smsdrafthomecontroller';
        $scope.smsDrafts = dataservices.smsDrafts;
        

        ////////////////////////   Initialize the list of Sms drafts   /////////////////////////////////

       
        dataservices.getSMSDrafts().then(function (result) {            
         //   $scope.smsDrafts = result;            
        }, function () { })


        /////////////// ngTable
        function ngTableFunction() {
            $scope.tableParams = new ngTableParams({
                page: 1,            // show first page
                count: 10,          // count per page
                sorting: {
                    name: 'asc'     // initial sorting
                }
            }, {
                total: $scope.smsDrafts.length, // length of data
                getData: function ($defer, params) {
                    // use build-in angular filter
                    var orderedData = params.sorting() ? $filter('orderBy')($scope.smsDrafts, params.orderBy()) : $scope.smsDrafts;

                    $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
                }
            });
        }

        
        ////////////////////////     refresh the list of Sms draft   /////////////////////////////////

        $scope.Refresh = function () {
            dataservices.getSMSDrafts().then(function (result) {},
                function () {
                    //Error refreshing data set
                    notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
                });
        }


        ////////////////////////     Delete Sms draft   /////////////////////////////////


        function getSelectedMessages() {
            var messagesArray = [];
            for (var i = 0; i < $scope.smsDrafts.length; i++) {

                if ($scope.smsDrafts[i].isSelected == true) {
                    var messageDraft = {};

                    messageDraft.id = $scope.smsDrafts[i].id;
                    messageDraft.text = $scope.smsDrafts[i].text;
                    messageDraft.message = $scope.smsDrafts[i].message;
                    messageDraft.date = $scope.smsDrafts[i].date;
                    messagesArray.push(messageDraft);
                }
            }

            return messagesArray;
        }

        $scope.Delete = function () {

            if (getSelectedMessages().length < 1) {
                notificationFactory.error('Please select Draft to delete');
            }
            else {
                //make a call to the delete service pass the array of messages

                var selectedMessages = getSelectedMessages();

                communicationDataServices.removeSmsDraftData(selectedMessages)
                    .then(function (result) {               
                    
                        notificationFactory.success( 'drafts Deleted');

                },
                 function () {

                     notificationFactory.error('Delete not successful, please check the internet and try again.');

                 });
            }            
            
        }
       
    }
})();
