﻿(function () {
    'use strict';  


        var controllerId = 'testimoniesController';

        // TODO: replace app with your module name
        churchplusapp.controller(controllerId, ['$scope', 'testimonydataservices', 'notificationFactory', 'ngTableParams', '$filter', testimoniesController]);

        
        function testimoniesController($scope, testimonydataservices, notificationFactory, ngTableParams, $filter) {
            $scope.title = 'testimoniesController';

            $scope.data = testimonydataservices;

            //Load testimonies
            if (testimonydataservices.IsTestimoniesDataInitialized() == false) {
                testimonydataservices.getTestimoniesData().then(function () {
                    //success   
                    ngTableFunction();
                },
             function () {
                 //failure
                 alert('Something wrong just happened');
             });
            }
            else {
                ngTableFunction();
            }


            //////ng-table tins
            function ngTableFunction() {
                $scope.tableParams = new ngTableParams({
                    page: 1,            // show first page
                    count: 10,          // count per page
                    sorting: {
                        name: 'asc'     // initial sorting
                    }
                }, {
                    total: $scope.data.testimonies.length, // length of data
                    getData: function ($defer, params) {
                        // use build-in angular filter
                        var filteredData = params.filter() ?
                            $filter('filter')($scope.data.testimonies, params.filter()) :
                            $scope.data.testimonies;
                        var orderedData = params.sorting() ?
                                $filter('orderBy')(filteredData, params.orderBy()) :
                                $scope.data.testimonies;

                        params.total(orderedData.length); // set total for recalc pagination                    
                        $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
                      
                    }
                });

            }

            //refresh testimonies
            $scope.Refresh = function () {

                testimonydataservices.getTestimoniesData().then(function () { },
                    function () {
                        //Error refreshing data set
                        notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
                    });;

            }

            //remove testimony
            $scope.Remove = function (testimonyID) {
                testimonydataservices.removeTestimonyData(testimonyID).then(function (t) {
                    notificationFactory.success('Testimony removed');
                }, function (t) {
                    notificationFactory.error(t);
                });

            }

            $scope.ConfirmDelete = function (testimonyID) {
                if (confirm("Are you sure to want to Delete?") == true) {
                    $scope.Remove(testimonyID)
                }

            }

            function activate() {
                alert('loaded')
            }

        }       
    }
)();
