﻿(function () {
    'use strict';   

        var serviceId = 'testimonydataservices';

    // TODO: replace app with your module name
        churchplusapp.factory(serviceId, ['$http', '$q', testimonydataservices]);

        function testimonydataservices($http, $q) {
        // Define the functions and properties to reveal.

        var _testimonies = [];
        
        var _initTestimonies = false;

        var service = {

            testimonies: _testimonies,            
            getTestimoniesData: getTestimoniesData,
            addTestimonyData : addTestimonyData,
            removeTestimonyData: removeTestimonyData,
            IsTestimoniesDataInitialized: IsTestimoniesDataInitialized,
            getTestimonyDataForEdit: getTestimonyDataForEdit
            
           // gettestimonyDataForEdit: gettestimonyDataForEdit
        };

        return service;

       
        //function for getting all the testimonies

        function getTestimoniesData() {
            var deferred = $q.defer();

            $http.get('api/TestimoniesController/GetTestimoniesData').then(function (result) {
                //successful call
                angular.copy(result.data, _testimonies);
                _initTestimonies = true;

                deferred.resolve();
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;
        }

        

        //function for add an testimony

        function addTestimonyData(testimonyData) {
            var deferred = $q.defer();

            var testimonyDataToEdit;
            if (testimonyData.id != null) {
                testimonyDataToEdit = testimonyData;
            }

            $http.post('api/TestimoniesController/SaveTestimony', testimonyData).then(function (result) {

                if (testimonyDataToEdit != null) {
                    for (var i = 0; _testimonies.length > i; i++) {
                        if (_testimonies[i].id === testimonyData.id) {
                            //console.log(i);
                            _testimonies.splice(i, 1, testimonyData);
                            break;
                        }
                    }


                } else {

                    _testimonies.splice(0, 0, result.data);
                }

                deferred.resolve(result.data);

            }, function (result) {

                deferred.reject(result.data);
            });

            return deferred.promise;

        }


        function getTestimonyDataForEdit(id) {
            var deferred = $q.defer();

            $http({
                method: 'get',
                url: 'api/TestimoniesController/GetSingleTestimony',
                params: { id: id }
            }).then(function (result) {
                //successful call

                deferred.resolve(result.data);
            },
            function () {
                //error in call
                deferred.reject();
            });
            return deferred.promise;

        }


        function removeTestimonyData(testimonyDataID) {
            var deferred = $q.defer();

            $http({
                method: 'delete',
                url: 'api/TestimoniesController/DeleteTestimony',
                params: { ID: testimonyDataID }
            })
                .then(function (result) {
                    for (var i = 0; _testimonies.length > i; i++) {
                        if (_testimonies[i].id === testimonyDataID) {
                            _testimonies.splice(_testimonies.indexOf(_testimonies[i]), 1);                            
                            break;
                        }

                    }
                    deferred.resolve(result.data);
                },
            function () {
                deferred.reject();
            });

            return deferred.promise;

            //$http.delete('api/TestimoniesController/DeleteTestimony' + testimonyData.id)
            //    .then(function (result) {
            //        _testimonies.splice(_testimonies.indexOf(testimonyData), 1);
            //        deferred.resolve(testimonyData);

            //}, function (result) {

            //    deferred.reject(result);
            //});

            //return deferred.promise;

        }


        function IsTestimoniesDataInitialized() {
            return _initTestimonies;
        }


    }




        function activate() { }
    }
)();
