﻿
(function () {
    'use strict';

    var controllerId = 'zoneNewEditController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', '$window', '$routeParams', 'cellFellowshipDataServices', 'notificationFactory', '$filter', 'ngTableParams', zoneNewEditController]);

    function zoneNewEditController($scope, $window, $routeParams, cellFellowshipDataServices, notificationFactory, $filter, ngTableParams) {
        $scope.title = 'zoneNewEditController';
        $scope.zone = {};
        $scope.houseFellowshipCenters = [];

        if ($routeParams.id) {
            cellFellowshipDataServices.getSingleZoneData($routeParams.id)
             .then(function (result) {
                 //@ Success
                 $scope.zone = result;
                 cellFellowshipDataServices.getHouseFellowshipsForZone($routeParams.id)
                 .then(function (result) { $scope.houseFellowshipCenters = result;}, function () { });
                 //$scope.houseFellowshipCenters = $scope.zone.cellCenters;                 
                 ngTableFunction();
             },
             function () {
                 //Error refreshing data set
                 notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
             });
        }
        else {
            ngTableFunction();
        }

        ////////////////////////// ng table for the housefellowships under each zone
        
        function ngTableFunction() {

            $scope.tableParams = new ngTableParams({
                page: 1,            // show first page
                count: 10,          // count per page
                sorting: {
                    name: 'asc'     // initial sorting
                }
            }, {
                total: $scope.houseFellowshipCenters.length, // length of data
                getData: function ($defer, params) {
                    // use build-in angular filter
                    var orderedData = params.sorting() ? $filter('orderBy')($scope.houseFellowshipCenters, params.orderBy()) : $scope.houseFellowshipCenters;

                    $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
                }
            });

        }

        //////////////////// function for saving a zone

        $scope.Save = function () {
            cellFellowshipDataServices.saveZoneData($scope.zone)
                .then(function (result) {
                    //@ Success  

                    $window.location = "#/Zone"

                }, function () {
                    //@ Failure
                    notificationFactory.error("Unsuccessful Operation");
                });
        }

        //////////////////// function from deleting house fellowship from a zone
        $scope.Remove = function (houseFellowship) {
            cellFellowshipDataServices.deleteHouseFellowshipData(houseFellowship.id).then(function (r) {
                $scope.houseFellowshipCenters.splice($scope.houseFellowshipCenters.indexOf(houseFellowship), 1);
                notificationFactory.success("House Fellowship Removed");
            }, function (r) {
                notificationFactory.error(r);
            });
        }

    }
})();

