﻿
(function () {
    'use strict';

    var controllerId = 'zonesHomeController';

    // TODO: replace app with your module name
    churchplusapp.controller(controllerId,
        ['$scope', '$window', 'cellFellowshipDataServices', 'notificationFactory', 'dataservices', zonesHomeController]);

    function zonesHomeController($scope, $window, cellFellowshipDataServices, notificationFactory, dataservices) {

        $scope.title = 'zonesHomeController';
        $scope.data = cellFellowshipDataServices.zoneData;

        // @ Check Initialization....
        if (cellFellowshipDataServices.isZoneDataInitialized() == false) {
            //@ Get Data
            cellFellowshipDataServices.getAllZoneData()
                .then(function () {
                    //@ Success  

                },
         function () {
             //@ Failure
             notificationFactory.error('Error loading data...');
         });
        }

        //Refresh Data
        $scope.Refresh = function () {
            cellFellowshipDataServices.getAllZoneData()
                .then(function () {
                    //@ Success

                },
                function () {
                    //Error refreshing data set
                    notificationFactory.error('Can not retrive data from the server now, please check internet connections and try again');
                });
        }

        //Remove Data
        $scope.Remove = function (a) {
            if (confirm("Are you sure you want to delete this zone")) {
                cellFellowshipDataServices.deleteZoneData(a)
                    .then(function (a) {
                        //@ Success

                        notificationFactory.success(a.id + ' successfully removed');
                    }, function (a) {
                        //@ Error

                        notificationFactory.error("Error occored while removing: " + a.id);
                    });
            }
        }

        $scope.Goto = function (url) {
            $window.location = url;
        }
    }
})();
